package org.msh.tb.bd.dashboard.detailedrep;

import org.jboss.seam.annotations.Name;
import org.jboss.seam.international.Messages;
import org.msh.tb.bd.dashboard.query.Indicator10Query;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.indicators.core.IndicatorTable;
import org.msh.utils.reportgen.highchart.ChartCreator;
import org.msh.utils.reportgen.highchart.ChartOptions;
import org.msh.utils.reportgen.highchart.Series;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * Created by Mauricio on 15/05/2017.
 */
@Name("detailedIndicator10")
public class DetailedIndicator10 extends DetailedIndicator<Indicator10Query> {

    @Override
    protected void createIndicators() {

        AdministrativeUnit auSelected = getIndicatorFilters().getTbunitselection().getAuselection().getSelectedUnit();

        // set params to indicator query
        getQuery().setIniDate(getIndicatorFilters().getIniDate());
        getQuery().setEndDate(getIndicatorFilters().getEndDate());
        getQuery().setSelectedAdminUnit(auSelected);

        List<Object[]> result = getQuery().getDetailedResult();

        // check root name
        String rootLabel = auSelected == null ? "Bangladesh" : auSelected.getCountryStructure().getName() + ": " + auSelected.getName().getName1();

        // populate indicator table
        for(Object[] r : result){
            String adminUnit = (String) r[0];
            Long newCasesNotif = (Long) r[1];
            Long allCasesNotif = (Long) r[2];
            Float rate = (Float) r[3];

            if (adminUnit.equals("root")) {
                adminUnit = rootLabel;
            }

            addValue(getMessage("dashboard.indicator10.closedcases"), adminUnit, newCasesNotif != null ? newCasesNotif.floatValue() : 0);
            addValue(getMessage("dashboard.indicator10.cases"), adminUnit, allCasesNotif != null ? allCasesNotif.floatValue() : 0);
            addValue(getMessage("dashboard.indicator10.rate"), adminUnit, rate);
        }

        // set highlight in root row
        getTable().getRows().get(getTable().getRows().size()-1).setHighlight(true);
    }

    @Override
    protected Indicator10Query getQueryNewInstance() {
        return new Indicator10Query();
    }

    /**
     * Create data to be generated by the chart
     */
    protected void createChartData() {
        if (getTable() == null)
            return;

        chartCreator = new ChartCreator();
        ChartOptions opt = chartCreator.getOptions();
        opt.getChart().setRenderTo("chartdiv");
        opt.getChart().setType(getIndicatorFilters().getHighChartType());
        Series series = opt.addSeries();

        String rateColumnLabel = Messages.instance().get("dashboard.indicator10.rate");
        series.setName(rateColumnLabel);

        for (IndicatorTable.TableRow row: getTable().getRows()) {
            for (IndicatorTable.TableCell cell: row.getCells()) {
                if (cell.getColumn().getTitle() != null && cell.getColumn().getTitle().equals(rateColumnLabel) && cell.getValue() > 0) {
                    BigDecimal bd = new BigDecimal(cell.getValue().doubleValue()).setScale(2, RoundingMode.HALF_EVEN);
                    series.addNewValue(bd.doubleValue());
                    opt.getxAxis().getCategories().add(cell.getRow().getTitle());
                }
            }
        }

        opt.getTitle().setText(Messages.instance().get("dashboard.indicator10"));
    }
}
